/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Path;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3962;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraft.class_6812;
import net.minecraft.class_6819;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.entity.Camel;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.entity.Penguin;
import samebutdifferent.ecologics.entity.Squirrel;
import samebutdifferent.ecologics.registry.ModBlockEntityTypes;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModConfiguration;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModFeatures;
import samebutdifferent.ecologics.registry.ModFoliagePlacerTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModMobEffects;
import samebutdifferent.ecologics.registry.ModPlacedFeatures;
import samebutdifferent.ecologics.registry.ModPotions;
import samebutdifferent.ecologics.registry.ModSigns;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import samebutdifferent.ecologics.registry.ModTrunkPlacerTypes;
import samebutdifferent.ecologics.util.CustomItemGroupBuilder;
import software.bernie.geckolib3.GeckoLib;

public class Ecologics
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "ecologics";
    public static final class_1761 TAB = CustomItemGroupBuilder.create("ecologics").icon(() -> new class_1799((class_1935)ModBlocks.COCONUT_LOG)).build();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("ecologics.json");
    public static ModConfiguration CONFIG;

    public void onInitialize() {
        CONFIG = (ModConfiguration)AutoConfig.register(ModConfiguration.class, GsonConfigSerializer::new).getConfig();
        ModBlocks.init();
        ModSigns.init();
        ModItems.init();
        ModSoundEvents.init();
        ModEntityTypes.init();
        ModBlockEntityTypes.init();
        ModFeatures.init();
        ModFoliagePlacerTypes.init();
        ModMobEffects.init();
        ModPotions.init();
        GeckoLib.initialize();
        this.addEvents();
        this.addEntityAttributes();
        ModTrunkPlacerTypes.register();
        class_1845.method_8074((class_1842)class_1847.field_8999, (class_1792)ModItems.PENGUIN_FEATHER, (class_1842)ModPotions.SLIDING);
        class_1845.method_8074((class_1842)ModPotions.SLIDING, (class_1792)class_1802.field_8725, (class_1842)ModPotions.LONG_SLIDING);
        StrippableBlockRegistry.register((class_2248)ModBlocks.COCONUT_LOG, (class_2248)ModBlocks.STRIPPED_COCONUT_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.COCONUT_WOOD, (class_2248)ModBlocks.STRIPPED_COCONUT_WOOD);
        StrippableBlockRegistry.register((class_2248)ModBlocks.WALNUT_LOG, (class_2248)ModBlocks.STRIPPED_WALNUT_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.WALNUT_WOOD, (class_2248)ModBlocks.STRIPPED_WALNUT_WOOD);
        StrippableBlockRegistry.register((class_2248)ModBlocks.AZALEA_LOG, (class_2248)ModBlocks.STRIPPED_AZALEA_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.AZALEA_WOOD, (class_2248)ModBlocks.STRIPPED_AZALEA_WOOD);
        StrippableBlockRegistry.register((class_2248)ModBlocks.FLOWERING_AZALEA_LOG, (class_2248)ModBlocks.STRIPPED_AZALEA_LOG);
        StrippableBlockRegistry.register((class_2248)ModBlocks.FLOWERING_AZALEA_WOOD, (class_2248)ModBlocks.STRIPPED_AZALEA_WOOD);
        class_3962.field_17566.put((Object)ModItems.COCONUT_SLICE, 0.3f);
        class_3962.field_17566.put((Object)ModBlocks.COCONUT_HUSK.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)ModBlocks.COCONUT_LEAVES.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)ModBlocks.WALNUT_LEAVES.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)ModBlocks.WALNUT_SAPLING.method_8389(), 0.3f);
        class_3962.field_17566.put((Object)ModBlocks.AZALEA_FLOWER.method_8389(), 0.65f);
        class_1317.method_20637(ModEntityTypes.CAMEL, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Camel::checkCamelSpawnRules);
        if (class_5458.field_35761.method_29113((Object)((class_6796)ModPlacedFeatures.ROOTED_AZALEA_TREE.comp_349())).isPresent()) {
            BiomeModifications.create((class_2960)new class_2960(MOD_ID, "remove_azalea_trees")).add(ModificationPhase.REPLACEMENTS, biomeSelectionContext -> biomeSelectionContext.getBiomeKey().equals(class_1972.field_29218), c -> {
                if (Ecologics.CONFIG.REPLACE_AZALEA_TREE) {
                    c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6812.field_35989.comp_349());
                    c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, (class_5321)class_5458.field_35761.method_29113((Object)((class_6796)ModPlacedFeatures.ROOTED_AZALEA_TREE.comp_349())).get());
                }
                if (Ecologics.CONFIG.GENERATE_SURFACE_MOSS) {
                    c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6812.field_35995.comp_349());
                    c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, (class_5321)class_5458.field_35761.method_29113((Object)((class_6796)ModPlacedFeatures.SURFACE_MOSS_PATCH.comp_349())).get());
                }
            });
        }
        if (class_5458.field_35761.method_29113((Object)((class_6796)ModPlacedFeatures.TREES_WALNUT.comp_349())).isPresent()) {
            BiomeModifications.create((class_2960)new class_2960(MOD_ID, "remove_oak_trees")).add(ModificationPhase.REPLACEMENTS, biomeSelectionContext -> biomeSelectionContext.getBiomeKey().equals(class_1972.field_9451), c -> {
                if (Ecologics.CONFIG.GENERATE_WALNUT_TREES) {
                    c.getGenerationSettings().removeBuiltInFeature((class_6796)class_6819.field_36135.comp_349());
                    c.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, (class_5321)class_5458.field_35761.method_29113((Object)((class_6796)ModPlacedFeatures.TREES_WALNUT.comp_349())).get());
                }
            });
        }
    }

    public void addPlacedFeatures() {
        if (Ecologics.CONFIG.GENERATE_COCONUT_TREES) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().method_29177().method_12832().equals("beach"), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeature(this.getPlacedFeatureIdentifier((class_6796)ModPlacedFeatures.TREES_BEACH.comp_349())));
        }
        if (Ecologics.CONFIG.GENERATE_SEASHELLS) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().method_29177().method_12832().equals("beach"), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeature(this.getPlacedFeatureIdentifier((class_6796)ModPlacedFeatures.SEASHELL.comp_349())));
        }
        if (Ecologics.CONFIG.GENERATE_THIN_ICE_PATCHES) {
            BiomeModifications.addFeature(biomeSelector -> biomeSelector.getBiomeKey().method_29177().method_12832().equals("frozen_river") || biomeSelector.getBiomeKey().method_29177().method_12832().equals("frozen_ocean") || biomeSelector.getBiomeKey().method_29177().equals((Object)"snowy_plains"), (class_2893.class_2895)class_2893.class_2895.field_13179, this.getPlacedFeature(this.getPlacedFeatureIdentifier((class_6796)ModPlacedFeatures.THIN_ICE_PATCH.comp_349())));
        }
        if (Ecologics.CONFIG.GENERATE_PRICKLY_PEARS) {
            BiomeModifications.addFeature(biomeSelector -> class_1959.method_40136((class_6880)biomeSelector.getBiomeRegistryEntry()).equals((Object)class_1959.class_1961.field_9368), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeature(this.getPlacedFeatureIdentifier((class_6796)ModPlacedFeatures.PRICKLY_PEAR.comp_349())));
        }
        if (Ecologics.CONFIG.GENERATE_DESERT_RUINS) {
            BiomeModifications.addFeature(biomeSelector -> class_1959.method_40136((class_6880)biomeSelector.getBiomeRegistryEntry()).equals((Object)class_1959.class_1961.field_9368), (class_2893.class_2895)class_2893.class_2895.field_13178, this.getPlacedFeature(this.getPlacedFeatureIdentifier((class_6796)ModPlacedFeatures.DESERT_RUIN.comp_349())));
        }
    }

    public void addSpawns() {
        if (Ecologics.CONFIG.SPAWN_PENGUINS) {
            BiomeModifications.addSpawn(biomeSelector -> biomeSelector.getBiomeKey().method_29177().method_12832().equals("frozen_river") || biomeSelector.getBiomeKey().method_29177().method_12832().equals("frozen_ocean") || biomeSelector.getBiomeKey().method_29177().equals((Object)"snowy_plains"), (class_1311)class_1311.field_6294, ModEntityTypes.PENGUIN, (int)2, (int)4, (int)7);
        }
        if (Ecologics.CONFIG.SPAWN_CAMELS) {
            BiomeModifications.addSpawn(biomeSelector -> class_1959.method_40136((class_6880)biomeSelector.getBiomeRegistryEntry()).equals((Object)class_1959.class_1961.field_9368), (class_1311)class_1311.field_6294, ModEntityTypes.CAMEL, (int)1, (int)1, (int)1);
        }
        if (Ecologics.CONFIG.SPAWN_SQUIRRELS) {
            BiomeModifications.addSpawn(biomeSelector -> biomeSelector.getBiomeKey().equals(class_1972.field_9451), (class_1311)class_1311.field_6294, ModEntityTypes.SQUIRREL, (int)10, (int)2, (int)3);
        }
    }

    public void addEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2680 state = world.method_8320(hitResult.method_17777());
            if (state.method_27852((class_2248)ModBlocks.POT) && player.method_18276()) {
                if (player.method_6047().method_7909() instanceof class_1810 && hand.equals((Object)class_1268.field_5808)) {
                    world.method_8501(hitResult.method_17777(), (class_2680)state.method_28493((class_2769)PotBlock.CHISEL));
                    world.method_8396(null, hitResult.method_17777(), class_3417.field_17710, class_3419.field_15245, 1.0f, world.method_8409().nextFloat() * 0.4f + 0.8f);
                    player.method_6104(class_1268.field_5808);
                    player.method_6047().method_7956(1, (class_1309)player, plr -> plr.method_20236(class_1268.field_5808));
                }
                if (player.method_6079().method_7909() instanceof class_1810 && !(player.method_6047().method_7909() instanceof class_1810) && hand.equals((Object)class_1268.field_5810)) {
                    world.method_8501(hitResult.method_17777(), (class_2680)state.method_28493((class_2769)PotBlock.CHISEL));
                    world.method_8396(null, hitResult.method_17777(), class_3417.field_17710, class_3419.field_15245, 1.0f, world.method_8409().nextFloat() * 0.4f + 0.8f);
                    player.method_6104(class_1268.field_5810);
                    player.method_6079().method_7956(1, (class_1309)player, plr -> plr.method_20236(class_1268.field_5808));
                }
            }
            return class_1269.field_5811;
        });
        this.addPlacedFeatures();
        this.addSpawns();
    }

    public void addEntityAttributes() {
        FabricDefaultAttributeRegistry.register(ModEntityTypes.COCONUT_CRAB, (class_5132.class_5133)CoconutCrab.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntityTypes.CAMEL, (class_5132.class_5133)Camel.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntityTypes.PENGUIN, (class_5132.class_5133)Penguin.createAttributes());
        FabricDefaultAttributeRegistry.register(ModEntityTypes.SQUIRREL, (class_5132.class_5133)Squirrel.createAttributes());
    }

    private class_5321<class_6796> getPlacedFeature(class_2960 placedFeatureId) {
        return class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)placedFeatureId);
    }

    private class_2960 getPlacedFeatureIdentifier(class_6796 placedFeature) {
        return class_5458.field_35761.method_10221((Object)placedFeature);
    }
}

